/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBallEntity;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record ClientBoundCannonballExplosionPacket(ExplosionType explosionType, Vec3 pos, float power, List<BlockPos> toBlow, @Nullable Vec3 knockback, int getId) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundCannonballExplosionPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("s2c_cannonball"), ClientBoundCannonballExplosionPacket::fromBuffer);

    public static ClientBoundCannonballExplosionPacket cannonball(CannonBallExplosion expl, CannonBallEntity source) {
        Vec3 pos = new Vec3(expl.x, expl.y, expl.z);
        return new ClientBoundCannonballExplosionPacket(ExplosionType.CANNONBALL, pos, expl.radius, expl.getToBlow(), source.getDeltaMovement(), source.getId());
    }

    static ClientBoundCannonballExplosionPacket fromBuffer(RegistryFriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        float power = buffer.readFloat();
        int i = Mth.floor((double)x);
        int j = Mth.floor((double)y);
        int k = Mth.floor((double)z);
        List toBlow = buffer.readList(friendlyByteBuf -> {
            int l = friendlyByteBuf.readByte() + i;
            int m = friendlyByteBuf.readByte() + j;
            int n = friendlyByteBuf.readByte() + k;
            return new BlockPos(l, m, n);
        });
        Vec3 knockback = buffer.readBoolean() ? new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()) : null;
        ExplosionType type = (ExplosionType)buffer.readEnum(ExplosionType.class);
        int id = buffer.readVarInt();
        return new ClientBoundCannonballExplosionPacket(type, new Vec3(x, y, z), power, toBlow, knockback, id);
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeDouble(this.pos.x);
        buffer.writeDouble(this.pos.y);
        buffer.writeDouble(this.pos.z);
        buffer.writeFloat(this.power);
        int i = Mth.floor((double)this.pos.x);
        int j = Mth.floor((double)this.pos.y);
        int k = Mth.floor((double)this.pos.z);
        buffer.writeCollection(this.toBlow, (friendlyByteBuf, blockPos) -> {
            int l = blockPos.getX() - i;
            int m = blockPos.getY() - j;
            int n = blockPos.getZ() - k;
            friendlyByteBuf.writeByte(l);
            friendlyByteBuf.writeByte(m);
            friendlyByteBuf.writeByte(n);
        });
        buffer.writeBoolean(this.knockback != null);
        if (this.knockback != null) {
            buffer.writeDouble(this.knockback.x);
            buffer.writeDouble(this.knockback.y);
            buffer.writeDouble(this.knockback.z);
        }
        buffer.writeEnum((Enum)this.explosionType);
        buffer.writeVarInt(this.getId);
    }

    public void handle(Message.Context context) {
        ClientReceivers.handleExplosionPacket(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }

    public static enum ExplosionType {
        CANNONBALL;

    }
}

